/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

class VWMilestoneUI
extends JComponent {
    private static final int MODE_NUM = 3;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_SELECTED = 1;
    private static final int MODE_FOCUS = 2;
    public static final int TYPE_PRE = 0;
    public static final int TYPE_POST = 1;
    public static final Dimension s_imageDim = new Dimension(8, 16);
    public static final int s_gap = 2;
    private Image[] m_milestoneImages = null;
    private Image[] m_startMilestoneImages = null;
    private VWStepDefinition m_stepDef = null;
    private int m_stepIcon_X = 0;
    private int m_stepIcon_Y = 0;
    private int m_width = 0;
    private int m_height = 0;
    private boolean m_bFocus = false;
    private boolean m_bSelect = false;
    private int m_type = 0;

    public VWMilestoneUI(int type, VWStepDefinition stepDef, int imageX, int imageY, int width, int height, boolean bFocus, boolean bSelect) {
        this.m_type = type;
        this.m_stepDef = stepDef;
        this.m_stepIcon_X = imageX;
        this.m_stepIcon_Y = imageY;
        this.m_width = width;
        this.m_height = height;
        this.m_bFocus = bFocus;
        this.m_bSelect = bSelect;
        this.m_milestoneImages = new Image[3];
        this.loadImages(this.m_milestoneImages, "milestone");
        this.m_startMilestoneImages = new Image[3];
        this.loadImages(this.m_startMilestoneImages, "start_milestone");
    }

    public void init(int imageX, int imageY, boolean bFocus, boolean bSelect) {
        this.m_stepIcon_X = imageX;
        this.m_stepIcon_Y = imageY;
        this.m_bFocus = bFocus;
        this.m_bSelect = bSelect;
    }

    public void paintComponent(Graphics g) {
        int x = this.getImageX_Coordinate();
        int y = this.getImageY_Coordinate();
        g.drawImage(this.getImage(), x, y, VWMilestoneUI.s_imageDim.width, VWMilestoneUI.s_imageDim.height, this);
    }

    public void printComponent(Graphics2D g2, PageFormat pf, int pi, int wp, int hp) {
        int row = pi / wp;
        int col = pi % wp;
        double iW = pf.getImageableWidth();
        double iH = pf.getImageableHeight();
        int pageX = (int)Math.round((double)col * iW);
        int pageY = (int)Math.round((double)row * iH);
        int pageX2 = pageX + (int)iW;
        int pageY2 = pageY + (int)iH;
        int imageXul = this.getImageX_Coordinate();
        int imageYul = this.getImageY_Coordinate();
        int imageXlr = imageXul + VWMilestoneUI.s_imageDim.width;
        int imageYlr = imageYul + VWMilestoneUI.s_imageDim.height;
        if (imageXul >= pageX && imageXul <= pageX2 && imageYul >= pageY && imageYul <= pageY2 || imageXlr >= pageX && imageXlr <= pageX2 && imageYlr >= pageY && imageYlr <= pageY2) {
            g2.drawImage(this.getImage(), imageXul - pageX, imageYul - pageY, VWMilestoneUI.s_imageDim.width, VWMilestoneUI.s_imageDim.height, this);
        }
    }

    protected Image getImage() {
        boolean bStart;
        Image image = null;
        int stepType = VWStepUtils.getStepType(this.m_stepDef);
        boolean bl = bStart = stepType == 0 || VWStepUtils.isStartStep(stepType);
        image = this.m_bFocus ? (bStart ? this.m_startMilestoneImages[2] : this.m_milestoneImages[2]) : (this.m_bSelect ? (bStart ? this.m_startMilestoneImages[1] : this.m_milestoneImages[1]) : (bStart ? this.m_startMilestoneImages[0] : this.m_milestoneImages[0]));
        return image;
    }

    protected void loadImages(Image[] images, String imageName) {
        if (images != null && images.length >= 3) {
            ImageIcon imageIcon = null;
            images[2] = null;
            images[1] = null;
            images[0] = null;
            imageIcon = VWImageLoader.createImageIcon(imageName + "_f.gif");
            if (imageIcon != null) {
                images[2] = imageIcon.getImage();
            }
            if ((imageIcon = VWImageLoader.createImageIcon(imageName + "_s.gif")) != null) {
                images[1] = imageIcon.getImage();
            }
            if ((imageIcon = VWImageLoader.createImageIcon(imageName + "_n.gif")) != null) {
                images[0] = imageIcon.getImage();
            }
        }
    }

    private int getImageX_Coordinate() {
        return this.m_type == 0 ? this.m_stepIcon_X - VWMilestoneUI.s_imageDim.width - 2 : this.m_stepIcon_X + this.m_width + 2;
    }

    private int getImageY_Coordinate() {
        return this.m_stepIcon_Y - VWMilestoneUI.s_imageDim.height / 2;
    }
}

